<?php

namespace Drupal\kate_demo\Form;

use Drupal\Core\Form\FormInterface;
use Drupal\Core\Form\FormStateInterface;

class eBayForm implements FormInterface {

	public function getFormID() {
		return 'ebay_form';
	}

	public function buildForm( array $form, FormStateInterface $form_state ) {
		$args 		=	func_get_args();
		$zipcode 	= 	isset( $args[ 2 ] ) ? $args[ 2 ] : '';

		$form			=	array();

		$form[ '#action' ] = '/kate_demo/ebay_form_submit';

		$form[ 'keywords' ]	=	array(
			'#type'		=>	'textfield',
			'#title'	=>	t( 'Keywords' ),
			'#size'		=>	80,
			'#maxlength'	=>	80,
			'#default_value'=>	'weather',
		);

		$form[ 'zipcode' ]	=	array(
			'#type'		=>	'textfield',
			'#title'	=>	t( 'Search near' ),
			'#size'		=>	5,
			'#maxlength'	=>	5,
			'#disabled'	=>	true,
			'#default_value'=>	$zipcode
		);

		// adding this because the disabled textfield doesn't show up in the post
		// results
		$form[ 'zipcode_h' ] = array(
			'#type'				=>	'hidden',
			'#default_value'	=>	$zipcode
		);

		$form[ 'num_results' ]	=	array(
			'#type'		=>	'select',
			'#title'	=>	t( 'Results to Show' ),
			'#options'	=>	array( 10 => 10, 20 => 20, 50 => 50 ),
			'#default_value'=>	10,
		);

		// drupal forms don't process properly unless they're actually submitted
		// via a submit element.  so I put one here but will make my javascript
		// make it invisible and then trigger the click event on it even though
		// it's invisible when the jQueryUI button is clicked instead...
		$form[ 'submit'	]	=	array(
			'#type'		=>	'submit',
			'#value'	=>	t( 'Submit' ),
		);

		return $form;
	}

	public function validateForm( array &$form, FormStateInterface $form_state ) {
		return true;
	}

	public function submitForm( array &$form, FormStateInterface $form_state ) {
		return true;
	}
}