"use strict";

const path = require("path");
const puppeteer = require("puppeteer-core");
const fs = require('fs');


(async () => {
    const htmlFile = path.resolve(process.argv[2]);
    const pdfFile = path.resolve(process.argv[3]);

    //console.log( htmlFile + ' ==> ' + pdfFile );

    const browser = await puppeteer.launch(
        {
            args: ['--disable-gpu', '--no-sandbox', '--disable-dev-shm-usage'],
            executablePath: '/usr/bin/chromium-browser',
            headless: true,
        });

    const page = await browser.newPage();

    const file_content = fs.existsSync(htmlFile) ? fs.readFileSync(htmlFile, 'utf8') : '';
    await page.setContent( file_content );
    await page.pdf({path: pdfFile, format: "Letter", printBackground: true});
    await browser.close();
})();
