jQuery( ( $ ) => {

    const coords = [ drupalSettings.openstreetmaps_maps_data.lat, drupalSettings.openstreetmaps_maps_data.lon ];
    const map = L.map( 'map-canvas' ).setView( coords, 12 );

    L.tileLayer('https://tile.openstreetmap.org/{z}/{x}/{y}.png', {
        maxZoom: 19,
        attribution: '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'
    }).addTo(map);

    const popup = L.popup().setLatLng( coords ).setContent( drupalSettings.openstreetmaps_maps_data.display_name )
        .openOn( map );

} );