<?php

namespace Drupal\kate_demo\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class KateDemoSettingsForm extends ConfigFormBase {
    const SETTINGS = 'kate_demo.settings';

    protected function getEditableConfigNames() {
        return [
            static::SETTINGS,
        ];
    }

    public function getFormId() {
        return 'kate_demo_admin_settings';
    }

    public function buildForm(array $form, FormStateInterface $form_state) {
        $config = $this->config( static::SETTINGS );

        $form[ 'google_api_key' ]	=	array(
            '#type'		    =>	'textfield',
            '#title'	    =>	$this->t( 'Google API Key' ),
            '#description'	=>	$this->t( 'For Google Maps integration' ),
            '#size'		    =>	40,
            '#maxlength'	=>	40,
            '#default_value'=>	\Drupal::config('kate_demo.settings')->get('google_api_key'),
        );

        $form[ 'google_oauth2_client_id' ]	=	array(
            '#type'		    =>	'textfield',
            '#title'	    =>	$this->t( 'Google OAuth2 Client ID' ),
            '#description'	=>	$this->t( 'For Google Data integration' ),
            '#size'		    =>	80,
            '#maxlength'	=>	150,
            '#default_value'=>	\Drupal::config('kate_demo.settings')->get('google_oauth2_client_id'),
        );

        $form[ 'google_oauth2_client_secret' ]=	array(
            '#type'		    =>	'textfield',
            '#title'	    =>	$this->t( 'Google OAuth2 Client Secret' ),
            '#description'	=>	$this->t( 'For Google Data integration' ),
            '#size'		    =>	80,
            '#maxlength'	=>	150,
            '#default_value'=>	\Drupal::config('kate_demo.settings')->get('google_oauth2_client_secret'),
        );

        $form[ 'oauth2_redirect_uri' ]	=	array(
            '#type'		    =>	'textfield',
            '#title'	    =>	$this->t( 'Google OAuth2 Redirect URI' ),
            '#description'	=>	$this->t( 'Must be one of the URIs configured in your Developer Console.' ),
            '#size'		    =>	80,
            '#maxlength'	=>	150,
            '#default_value'=>	\Drupal::config('kate_demo.settings')->get('oauth2_redirect_uri'),
        );

        $form[ 'facebook_app_id' ]		=	array(
            '#type'		=>	'textfield',
            '#title'	=>	$this->t( 'Facebook API App ID' ),
            '#size'		=>	20,
            '#maxlength'	=>	30,
            '#default_value'=>	\Drupal::config('kate_demo.settings')->get('facebook_app_id'),
        );

        $form[ 'ebay_devid' ]			=	array(
            '#type'		    =>	'textfield',
            '#title'	    =>	$this->t( 'eBay Dev ID' ),
            '#size'		    =>	60,
            '#maxlength'	=>	255,
            '#default_value'=>	\Drupal::config('kate_demo.settings')->get('ebay_devid'),
        );

        $form[ 'ebay_appid' ]			=	array(
            '#type'		    =>	'textfield',
            '#title'	    =>	$this->t( 'eBay App ID' ),
            '#size'		    =>	60,
            '#maxlength'	=>	255,
            '#default_value'=>	\Drupal::config('kate_demo.settings')->get('ebay_appid'),
        );

        $form[ 'ebay_certid' ]		=	array(
            '#type'		    =>	'textfield',
            '#title'	    =>	$this->t( 'eBay Cert ID' ),
            '#size'		    =>	60,
            '#maxlength'	=>	255,
            '#default_value'=>	\Drupal::config('kate_demo.settings')->get('ebay_certid'),
        );

        $form[ 'ebay_token' ]			=	array(
            '#type'		    =>	'textarea',
            '#title'	    =>	$this->t( 'eBay Token' ),
            '#default_value'=>	\Drupal::config('kate_demo.settings')->get('ebay_token'),
        );

        $form[ 'tomorrowio_api_key' ] 		=	array(
            '#type'		    =>	'textfield',
            '#title'	    =>	$this->t( 'Tomorrow.io API Key' ),
            '#default_value'=>	\Drupal::config('kate_demo.settings')->get('tomorrowio_api_key'),

        );

        return parent::buildForm($form, $form_state);
    }

    public function submitForm(array &$form, FormStateInterface $form_state) {
        // Retrieve the configuration.
        $editable = $this->configFactory->getEditable(static::SETTINGS);
        $formFields = array( 'google_api_key', 'google_oauth2_client_id', 'google_oauth2_client_secret',
            'oauth2_redirect_uri', 'facebook_app_id', 'ebay_devid', 'ebay_appid', 'ebay_certid', 'ebay_token',
            'tomorrowio_api_key' );
        foreach ( $formFields as $formField ) {
            $editable->set( $formField, $form_state->getValue( $formField ) );
        }
        $editable->save();
        parent::submitForm($form, $form_state);
    }

}